/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.wizard;

import com.aptana.deploy.wizard.DataTransferWizardCollectionComparator;
import com.aptana.deploy.wizard.DeployWizardRegistry;
import com.aptana.deploy.wizard.WorkbenchMessages;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WizardActivityFilter;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class DeployWizardPage
extends WorkbenchWizardSelectionPage {
    protected static final String DIALOG_SETTING_SECTION_NAME = "DeployWizardPage.";
    private static final String STORE_SELECTED_DEPLOY_WIZARD_ID = "DeployWizardPage.STORE_SELECTED_DEPLOY_WIZARD_ID";
    private static final String STORE_EXPANDED_DEPLOY_CATEGORIES = "DeployWizardPage.STORE_EXPANDED_DEPLOY_CATEGORIES";
    CategorizedWizardSelectionTree wizardTree;
    private TreeViewer treeViewer;
    private Label descriptionLabel;

    protected DeployWizardPage(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        super("deployWizardPage", aWorkbench, currentSelection, null, null);
        this.setTitle(WorkbenchMessages.DeployWizardPage_DeploymentOption);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(0, 10).create());
        outerContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        outerContainer.setFont(font);
        Composite comp = this.createTreeViewer(outerContainer);
        Dialog.applyDialogFont((Control)comp);
        this.descriptionLabel = new Label(comp, 64);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, 50).create());
            this.descriptionLabel.setFont(font);
        }
        this.restoreWidgetValues();
        this.setControl((Control)outerContainer);
        this.initialize();
    }

    protected Composite createTreeViewer(Composite parent) {
        IWizardCategory root = DeployWizardRegistry.getInstance().getRootCategory();
        this.wizardTree = new CategorizedWizardSelectionTree(root, WorkbenchMessages.DeployWizardPage_SelectDeploymentProvider);
        Composite exportComp = this.wizardTree.createControl(parent);
        this.wizardTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeployWizardPage.this.listSelectionChanged(event.getSelection());
            }
        });
        this.wizardTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DeployWizardPage.this.treeDoubleClicked(event);
            }
        });
        this.setTreeViewer(this.wizardTree.getViewer());
        return exportComp;
    }

    protected void treeDoubleClicked(DoubleClickEvent event) {
        ISelection selection = event.getViewer().getSelection();
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.listSelectionChanged((ISelection)ss);
        Object element = ss.getFirstElement();
        TreeViewer v = (TreeViewer)event.getViewer();
        if (v.isExpandable(element)) {
            v.setExpandedState(element, !v.getExpandedState(element));
        } else if (element instanceof WorkbenchWizardElement && this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
            return;
        }
        this.getContainer().showPage(this.getNextPage());
    }

    private void updateSelectedNode(WorkbenchWizardElement wizardElement) {
        this.setErrorMessage(null);
        if (wizardElement == null) {
            this.updateMessage();
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode((IWizardDescriptor)wizardElement));
        this.descriptionLabel.setText(wizardElement.getDescription());
    }

    protected void updateMessage() {
        this.setMessage(WorkbenchMessages.DeployWizardPage_SelectYourDesiredDeploymentOption);
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            ISelection selection = viewer.getSelection();
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object sel = ss.getFirstElement();
            if (sel instanceof WorkbenchWizardElement) {
                this.updateSelectedNode((WorkbenchWizardElement)sel);
            } else {
                this.setSelectedNode(null);
            }
        } else {
            this.descriptionLabel.setText(null);
        }
    }

    protected void listSelectionChanged(ISelection selection) {
        this.setErrorMessage(null);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object sel = ss.getFirstElement();
        if (sel instanceof WorkbenchWizardElement) {
            WorkbenchWizardElement currentWizardSelection = (WorkbenchWizardElement)sel;
            this.updateSelectedNode(currentWizardSelection);
        } else {
            this.updateSelectedNode(null);
        }
    }

    private IWizardNode createWizardNode(IWizardDescriptor element) {
        return new WorkbenchWizardNode(this, element){

            public IWorkbenchWizard createWizard() throws CoreException {
                return this.wizardElement.createWizard();
            }
        };
    }

    protected void restoreWidgetValues() {
        IWizardCategory exportRoot = WorkbenchPlugin.getDefault().getExportWizardRegistry().getRootCategory();
        this.expandPreviouslyExpandedCategories(STORE_EXPANDED_DEPLOY_CATEGORIES, exportRoot, this.wizardTree.getViewer());
        this.selectPreviouslySelected(STORE_SELECTED_DEPLOY_WIZARD_ID, exportRoot, this.wizardTree.getViewer());
        this.updateMessage();
    }

    protected void expandPreviouslyExpandedCategories(String setting, IWizardCategory wizardCategories, TreeViewer viewer) {
        String[] expandedCategoryPaths = this.getDialogSettings().getArray(setting);
        if (expandedCategoryPaths == null || expandedCategoryPaths.length == 0) {
            return;
        }
        ArrayList<IWizardCategory> categoriesToExpand = new ArrayList<IWizardCategory>(expandedCategoryPaths.length);
        if (wizardCategories != null) {
            int i = 0;
            while (i < expandedCategoryPaths.length) {
                IWizardCategory category = wizardCategories.findCategory((IPath)new Path(expandedCategoryPaths[i]));
                if (category != null) {
                    categoriesToExpand.add(category);
                }
                ++i;
            }
        }
        if (!categoriesToExpand.isEmpty()) {
            viewer.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected void selectPreviouslySelected(String setting, IWizardCategory wizardCategories, TreeViewer viewer) {
        String selectedId = this.getDialogSettings().get(setting);
        if (selectedId == null) {
            return;
        }
        if (wizardCategories == null) {
            return;
        }
        IWizardCategory selected = wizardCategories.findCategory((IPath)new Path(selectedId));
        if (selected == null && (selected = wizardCategories.findWizard(selectedId)) == null) {
            return;
        }
        viewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
    }

    protected void storeExpandedCategories(String setting, TreeViewer viewer) {
        Object[] expandedElements = viewer.getExpandedElements();
        ArrayList<String> expandedElementPaths = new ArrayList<String>(expandedElements.length);
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IWizardCategory) {
                expandedElementPaths.add(((IWizardCategory)element).getPath().toString());
            }
            ++n2;
        }
        this.getDialogSettings().put(setting, expandedElementPaths.toArray(new String[expandedElementPaths.size()]));
    }

    protected void storeSelectedCategoryAndWizard(String setting, TreeViewer viewer) {
        Object selected = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (selected != null) {
            if (selected instanceof IWizardCategory) {
                this.getDialogSettings().put(setting, ((IWizardCategory)selected).getPath().toString());
            } else {
                this.getDialogSettings().put(setting, ((IWizardDescriptor)selected).getId());
            }
        }
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories(STORE_EXPANDED_DEPLOY_CATEGORIES, this.wizardTree.getViewer());
        this.storeSelectedCategoryAndWizard(STORE_SELECTED_DEPLOY_WIZARD_ID, this.wizardTree.getViewer());
    }

    public IWizardPage getNextPage() {
        ITriggerPoint triggerPoint = this.getTriggerPoint();
        if (triggerPoint == null || WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)this.getSelectedNode())) {
            return super.getNextPage();
        }
        return null;
    }

    protected ITriggerPoint getTriggerPoint() {
        return null;
    }

    protected void setTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void initialize() {
    }

    protected static class CategorizedWizardSelectionTree {
        private static final int SIZING_LISTS_HEIGHT = 200;
        private IWizardCategory wizardCategories;
        private String message;
        private TreeViewer viewer;

        protected CategorizedWizardSelectionTree(IWizardCategory categories, String msg) {
            this.wizardCategories = categories;
            this.message = msg;
        }

        protected Composite createControl(Composite parent) {
            Font font = parent.getFont();
            Composite outerContainer = new Composite(parent, 0);
            outerContainer.setLayout((Layout)new GridLayout());
            outerContainer.setLayoutData((Object)new GridData(1808));
            outerContainer.setFont(font);
            Label messageLabel = new Label(outerContainer, 0);
            if (this.message != null) {
                messageLabel.setText(this.message);
            }
            messageLabel.setFont(font);
            this.createFilteredTree(outerContainer);
            this.layoutTopControl(this.viewer.getControl());
            return outerContainer;
        }

        private void createFilteredTree(Composite parent) {
            FilteredTree filteredTree = new FilteredTree(parent, 2820, (PatternFilter)new WizardPatternFilter(), true);
            this.viewer = filteredTree.getViewer();
            filteredTree.setFont(parent.getFont());
            this.viewer.setContentProvider((IContentProvider)new WizardContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.viewer.setComparator((ViewerComparator)DataTransferWizardCollectionComparator.INSTANCE);
            ArrayList<IWizardCategory> inputArray = new ArrayList<IWizardCategory>();
            boolean expandTop = false;
            if (this.wizardCategories != null) {
                if (this.wizardCategories.getParent() == null) {
                    IWizardCategory[] children = this.wizardCategories.getCategories();
                    int i = 0;
                    while (i < children.length) {
                        inputArray.add(children[i]);
                        ++i;
                    }
                } else {
                    expandTop = true;
                    inputArray.add(this.wizardCategories);
                }
            }
            if (expandTop) {
                this.viewer.setAutoExpandLevel(2);
            }
            AdaptableList input = new AdaptableList(inputArray);
            this.viewer.addFilter((ViewerFilter)new WizardActivityFilter());
            this.viewer.setInput((Object)input);
        }

        protected TreeViewer getViewer() {
            return this.viewer;
        }

        private void layoutTopControl(Control control) {
            GridData data = new GridData(1808);
            int availableRows = DialogUtil.availableRows((Composite)control.getParent());
            data.heightHint = availableRows > 40 ? 200 : availableRows * 2;
            control.setLayoutData((Object)data);
        }
    }
}

